/*!
 *
 *  Vision Helpdesk Icons 7.1
 *  The complete set of 701 with 109 Alias icons
 *
 *  Created by: ViJaY aHiRe @vijay_ahire
 *	Copyright (C) CC BY 4.0
 *	This software is the property of http://visionhelpdesk.com
 */
 /* To avoid CSS expressions while still supporting IE 7 and IE 6, use this script */
/* The script tag referencing this file must be placed before the ending body tag. */

/* Use conditional comments in order to target IE 7 and older:
	<!--[if lt IE 8]><!-->
	<script src="ie7/ie7.js"></script>
	<!--<![endif]-->
*/

(function() {
	function addIcon(el, entity) {
		var html = el.innerHTML;
		el.innerHTML = '<span style="font-family: \'vh-icons\'">' + entity + '</span>' + html;
	}
	var icons = {
		'vh-empty': '&#x00a0;',	
							
		'vh-home': '&#xf000;',	
		'vh-client': '&#xf001;',	
		'vh-setting': '&#xf002;',	
		'vh-self-help': '&#xf003;',	
		'vh-blab': '&#xf004;',	
		'vh-report': '&#xf005;',	
		'vh-online': '&#xf006;',	
		'vh-billing': '&#xf007;',	
		'vh-channel': '&#xf008;',	
		'vh-module': '&#xf009;',	
		'vh-diagnostic': '&#xf00a;',	
		'vh-backup': '&#xf00b;',	
		'vh-license': '&#xf00c;',	
		'vh-domain': '&#xf00d;',	
		'vh-department': '&#xf00e;',	
		'vh-ticket-status': '&#xf00f;',	
		'vh-ticket-priority': '&#xf010;',	
		'vh-ticket-type': '&#xf011;',	
		'vh-ticket-level': '&#xf012;',	
		'vh-ticket-category': '&#xf013;',	
		'vh-ticket-time': '&#xf014;',	
		'vh-ticket-time-1': '&#xf015;',	
		'vh-ticket-time-2': '&#xf016;',	
		'vh-ticket-setting': '&#xf017;',	
		'vh-label': '&#xf018;',	
		'vh-flag': '&#xf019;',	
		'vh-flag-filled': '&#xf019;',	// Alias
		'vh-flag-empty': '&#xf01a;',	
		'vh-flag-inner': '&#xf01b;',	
		'vh-language': '&#xf01c;',	
		'vh-agent': '&#xf01d;',	
		'vh-staff': '&#xf01e;',	
		'vh-user': '&#xf01e;',	// Alias
		'vh-staff-group': '&#xf01f;',	
		'vh-user-group': '&#xf01f;',	// Alias
		'vh-users': '&#xf01f;',	// Alias
		'vh-admin-access': '&#xf020;',	
		'vh-workflow': '&#xf021;',	
		'vh-sla': '&#xf022;',	
		'vh-sla-1': '&#xf023;',	
		'vh-schedule': '&#xf024;',	
		'vh-calendar': '&#xf025;',	
		'vh-holiday': '&#xf026;',	
		'vh-event': '&#xf027;',	
		'vh-bell': '&#xf028;',	
		'vh-alert': '&#xf028;',	// Alias
		'vh-email-queue': '&#xf029;',	
		'vh-outward-email': '&#xf02a;',	
		'vh-smtp': '&#xf02a;',	// Alias
		'vh-inward-email': '&#xf02b;',	
		'vh-breakline': '&#xf02c;',	
		'vh-email-template': '&#xf02d;',	
		'vh-email-template-mapping': '&#xf02e;',	
		'vh-product': '&#xf02f;',	
		'vh-product-ticketbase': '&#xf030;',	
		'vh-product-timebase': '&#xf031;',	
		'vh-product-chatbase': '&#xf032;',	
		'vh-product-callbase': '&#xf033;',	
		'vh-product-settings': '&#xf034;',	
		'vh-payment-gateway': '&#xf035;',	
		'vh-tax-rule': '&#xf036;',	
		'vh-custom-field': '&#xf037;',	
		'vh-custom-field-group': '&#xf038;',	
		'vh-key': '&#xf039;',	
		'vh-single-login': '&#xf039;',	// Alias
		'vh-integration': '&#xf03a;',	
		'vh-manage-portal': '&#xf03b;',	
		'vh-client-portal': '&#xf03c;',	
		'vh-error': '&#xf03d;',	
		'vh-parser': '&#xf03e;',	
		'vh-sent-email': '&#xf03f;',	
		'vh-gateway-transactions': '&#xf040;',	
		'vh-pin': '&#xf041;',	
		'vh-unpin': '&#xf042;',	
		'vh-google-adwords': '&#xf043;',	
		'vh-online-ads': '&#xf044;',	
		'vh-print-ads': '&#xf045;',	
		'vh-directory-listing': '&#xf046;',	
		'vh-refferral': '&#xf047;',	
		'vh-webinar': '&#xf048;',	
		'vh-seminar': '&#xf049;',	
		'vh-stall': '&#xf04a;',	
		'vh-hangouts': '&#xf04b;',	
		'vh-hangouts-round': '&#xf04c;',	
		'vh-hangouts-square': '&#xf04d;',	
		'vh-twitter': '&#xf04e;',	
		'vh-twitter-round': '&#xf04f;',	
		'vh-twitter-square': '&#xf050;',	
		'vh-facebook': '&#xf051;',	
		'vh-facebook-round': '&#xf052;',	
		'vh-facebook-square': '&#xf053;',	
		'vh-google': '&#xf054;',	
		'vh-google-round': '&#xf055;',	
		'vh-google-square': '&#xf056;',	
		'vh-google-plus': '&#xf057;',	
		'vh-google-plus-round': '&#xf058;',	
		'vh-google-plus-square': '&#xf059;',	
		'vh-linkedin': '&#xf05a;',	
		'vh-linkedin-round': '&#xf05b;',	
		'vh-linkedin-square': '&#xf05c;',	
		'vh-youtube': '&#xf05d;',	
		'vh-youtube-round': '&#xf05e;',	
		'vh-youtube-square': '&#xf05f;',	
		'vh-pinterest': '&#xf060;',	
		'vh-pinterest-round': '&#xf061;',	
		'vh-pinterest-square': '&#xf062;',	
		'vh-skype': '&#xf063;',	
		'vh-skype-round': '&#xf064;',	
		'vh-skype-square': '&#xf065;',	
		'vh-sms': '&#xf066;',	
		'vh-sms-round': '&#xf067;',	
		'vh-sms-square': '&#xf068;',	
		'vh-email': '&#xf069;',	
		'vh-inbox': '&#xf069;',	// Alias
		'vh-ticket': '&#xf069;',	// Alias
		'vh-envelope': '&#xf069;',	// Alias
		'vh-email-round': '&#xf06a;',	
		'vh-inbox-round': '&#xf06a;',	// Alias
		'vh-ticket-round': '&#xf06a;',	// Alias
		'vh-envelope-round': '&#xf06a;',	// Alias
		'vh-email-square': '&#xf06b;',	
		'vh-inbox-square': '&#xf06b;',	// Alias
		'vh-ticket-square': '&#xf06b;',	// Alias
		'vh-envelope-square': '&#xf06b;',	// Alias
		'vh-phone': '&#xf06c;',	
		'vh-call': '&#xf06c;',	// Alias
		'vh-phone-round': '&#xf06d;',	
		'vh-call-round': '&#xf06d;',	// Alias
		'vh-phone-square': '&#xf06e;',	
		'vh-call-square': '&#xf06e;',	// Alias
		'vh-chat': '&#xf06f;',	
		'vh-chat-round': '&#xf070;',	
		'vh-chat-square': '&#xf071;',	
		'vh-fax': '&#xf072;',	
		'vh-fax-round': '&#xf073;',	
		'vh-fax-square': '&#xf074;',	
		'vh-mobile': '&#xf075;',	
		'vh-cellphone': '&#xf075;',	// Alias
		'vh-mobile-round': '&#xf076;',	
		'vh-cellphone-round': '&#xf076;',	// Alias
		'vh-mobile-square': '&#xf077;',	
		'vh-cellphone-square': '&#xf077;',	// Alias
		'vh-question': '&#xf078;',	
		'vh-problem-management': '&#xf078;',	// Alias
		'vh-question-round': '&#xf079;',	
		'vh-question-square': '&#xf07a;',	
		'vh-information': '&#xf07b;',	
		'vh-information-round': '&#xf07c;',	
		'vh-information-square': '&#xf07d;',	
		'vh-minus': '&#xf07e;',	
		'vh-delete': '&#xf07e;',	// Alias
		'vh-less': '&#xf07e;',	// Alias
		'vh-minus-round': '&#xf07f;',	
		'vh-delete-round': '&#xf07f;',	// Alias
		'vh-less-round': '&#xf07f;',	// Alias
		'vh-minus-square': '&#xf080;',	
		'vh-delete-square': '&#xf080;',	// Alias
		'vh-less-square': '&#xf080;',	// Alias
		'vh-plus': '&#xf081;',	
		'vh-add': '&#xf081;',	// Alias
		'vh-more': '&#xf081;',	// Alias
		'vh-plus-round': '&#xf082;',	
		'vh-add-round': '&#xf082;',	// Alias
		'vh-more-round': '&#xf082;',	// Alias
		'vh-plus-square': '&#xf083;',	
		'vh-add-square': '&#xf083;',	// Alias
		'vh-more-square': '&#xf083;',	// Alias
		'vh-rss': '&#xf084;',	
		'vh-rss-round': '&#xf085;',	
		'vh-rss-square': '&#xf086;',	
		'vh-share': '&#xf087;',	
		'vh-share-round': '&#xf088;',	
		'vh-share-square': '&#xf089;',	
		'vh-action': '&#xf08a;',	
		'vh-edit': '&#xf08b;',	
		'vh-history': '&#xf08c;',	
		'vh-folder-open': '&#xf08d;',	
		'vh-folder-closed': '&#xf08e;',	
		'vh-folder': '&#xf08e;',	// Alias
		'vh-folder-add': '&#xf08f;',	
		'vh-folder-remove': '&#xf090;',	
		'vh-folder-less': '&#xf090;',	// Alias
		'vh-article-add': '&#xf091;',	
		'vh-article-remove': '&#xf092;',	
		'vh-article-less': '&#xf092;',	// Alias
		'vh-power': '&#xf093;',	
		'vh-paperclip': '&#xf094;',	
		'vh-attachment': '&#xf094;',	// Alias
		'vh-filter': '&#xf095;',	
		'vh-check': '&#xf096;',	
		'vh-cross': '&#xf097;',	
		'vh-check-slim': '&#xf098;',	
		'vh-cross-slim': '&#xf099;',	
		'vh-view-on': '&#xf09a;',	
		'vh-view-off': '&#xf09b;',	
		'vh-link': '&#xf09c;',	
		'vh-link-1': '&#xf09d;',	
		'vh-link-2': '&#xf09e;',	
		'vh-link-3': '&#xf09f;',	
		'vh-unlink': '&#xf0a0;',	
		'vh-gmail': '&#xf0a1;',	
		'vh-yahoo': '&#xf0a2;',	
		'vh-wechat': '&#xf0a3;',	
		'vh-whatsapp': '&#xf0a4;',	
		'vh-paypal': '&#xf0a5;',	
		'vh-instagram': '&#xf0a6;',	
		'vh-open-share': '&#xf0a7;',	
		'vh-file': '&#xf0a8;',	
		'vh-file-o': '&#xf0a9;',	
		'vh-file-text': '&#xf0aa;',	
		'vh-file-text-1': '&#xf0ab;',	
		'vh-file-text-1-o': '&#xf0ac;',	
		'vh-file-pdf': '&#xf0ad;',	
		'vh-file-acrobat': '&#xf0ad;',	// Alias
		'vh-file-document': '&#xf0ae;',	
		'vh-file-word': '&#xf0ae;',	// Alias
		'vh-file-spreadsheet': '&#xf0af;',	
		'vh-file-excel': '&#xf0af;',	// Alias
		'vh-file-presentation': '&#xf0b0;',	
		'vh-file-powerpoint': '&#xf0b0;',	// Alias
		'vh-file-access': '&#xf0b1;',	
		'vh-file-openoffice': '&#xf0b2;',	
		'vh-file-zip': '&#xf0b3;',	
		'vh-file-archive': '&#xf0b3;',	// Alias
		'vh-file-code': '&#xf0b4;',	
		'vh-file-html': '&#xf0b5;',	
		'vh-file-script': '&#xf0b6;',	
		'vh-file-css': '&#xf0b6;',	// Alias
		'vh-file-database': '&#xf0b7;',	
		'vh-file-image': '&#xf0b8;',	
		'vh-file-photo': '&#xf0b8;',	// Alias
		'vh-file-audio': '&#xf0b9;',	
		'vh-file-video': '&#xf0ba;',	
		'vh-file-unknown': '&#xf0bb;',	
		// 'vh-': '&#xf0bc;',	
		// 'vh-': '&#xf0bd;',	
		// 'vh-': '&#xf0be;',	
		// 'vh-': '&#xf0bf;',	
		// 'vh-': '&#xf0c0;',	
		// 'vh-': '&#xf0c1;',	
		// 'vh-': '&#xf0c2;',	
		// 'vh-': '&#xf0c3;',	
		'vh-file-attach-image': '&#xf0c4;',	
		'vh-file-attach-youtube': '&#xf0c5;',	
		'vh-file-attach-video': '&#xf0c6;',	
		'vh-file-attach-video-1': '&#xf0c7;',	
		'vh-file-attach-audio': '&#xf0c8;',	
		'vh-bar-compact': '&#xf0c9;',	
		'vh-bars': '&#xf0ca;',	
		'vh-bars-3': '&#xf0cb;',	
		'vh-bars-4': '&#xf0cc;',	
		'vh-bars-4-thin': '&#xf0cd;',	
		'vh-align-force-justify': '&#xf0cd;',	// Alias
		'vh-grid-square': '&#xf0ce;',	
		'vh-grid-round': '&#xf0cf;',	
		'vh-anchor': '&#xf0d0;',	
		'vh-tag': '&#xf0d1;',	
		'vh-bookmark': '&#xf0d1;',	// Alias
		'vh-certificate': '&#xf0d2;',	
		'vh-license-type': '&#xf0d2;',	// Alias
		'vh-qr-code': '&#xf0d3;',	
		'vh-barcode': '&#xf0d4;',	
		'vh-barcode-1': '&#xf0d5;',	
		'vh-contacts': '&#xf0d6;',	
		'vh-trash': '&#xf0d7;',	
		'vh-trash-empty': '&#xf0d8;',	
		'vh-trash-1': '&#xf0d9;',	
		'vh-trash-2': '&#xf0da;',	
		'vh-camera': '&#xf0db;',	
		'vh-merge': '&#xf0dc;',	
		'vh-split': '&#xf0dd;',	
		'vh-black-king': '&#xf0de;',	
		'vh-king': '&#xf0de;',	// Alias
		'vh-white-king': '&#xf0df;',	
		'vh-king-empty': '&#xf0df;',	// Alias
		'vh-black-queen': '&#xf0e0;',	
		'vh-queen': '&#xf0e0;',	// Alias
		'vh-white-queen': '&#xf0e1;',	
		'vh-queen-empty': '&#xf0e1;',	// Alias
		'vh-black-rook': '&#xf0e2;',	
		'vh-rook': '&#xf0e2;',	// Alias
		'vh-white-rook': '&#xf0e3;',	
		'vh-rook-empty': '&#xf0e3;',	// Alias
		'vh-black-bishop': '&#xf0e4;',	
		'vh-bishop': '&#xf0e4;',	// Alias
		'vh-white-bishop': '&#xf0e5;',	
		'vh-bishop-empty': '&#xf0e5;',	// Alias
		'vh-black-knight': '&#xf0e6;',	
		'vh-knight': '&#xf0e6;',	// Alias
		'vh-white-knight': '&#xf0e7;',	
		'vh-knight-empty': '&#xf0e7;',	// Alias
		'vh-black-pawn': '&#xf0e8;',	
		'vh-pawn': '&#xf0e8;',	// Alias
		'vh-white-pawn': '&#xf0e9;',	
		'vh-pawn-empty': '&#xf0e9;',	// Alias
		'vh-star': '&#xf0ea;',	
		'vh-star-empty': '&#xf0eb;',	
		'vh-star-half': '&#xf0ec;',	
		'vh-star-half-empty': '&#xf0ed;',	
		'vh-thumbs-up': '&#xf0ee;',	
		'vh-thumbs-up-right': '&#xf0ee;',	// Alias
		'vh-thumbs-down': '&#xf0ef;',	
		'vh-thumbs-down-right': '&#xf0ef;',	// Alias
		'vh-thumbs-up-left': '&#xf0f0;',	
		'vh-thumbs-down-left': '&#xf0f1;',	
		'vh-zoom': '&#xf0f2;',	
		'vh-search': '&#xf0f2;',	// Alias
		'vh-quest': '&#xf0f2;',	// Alias
		'vh-zoom-in': '&#xf0f3;',	
		'vh-zoom-out': '&#xf0f4;',	
		'vh-notifications': '&#xf0f5;',	
		'vh-stopwatch': '&#xf0f6;',	
		'vh-clock': '&#xf0f7;',	
		'vh-timer': '&#xf0f7;',	// Alias
		'vh-lock': '&#xf0f8;',	
		'vh-unlock': '&#xf0f9;',	
		'vh-log-in': '&#xf0fa;',	
		'vh-sign-in': '&#xf0fa;',	// Alias
		'vh-log-out': '&#xf0fb;',	
		'vh-sign-out': '&#xf0fb;',	// Alias
		'vh-spade': '&#xf0fc;',	
		'vh-spade-empty': '&#xf0fd;',	
		'vh-heart': '&#xf0fe;',	
		'vh-heart-empty': '&#xf0ff;',	
		'vh-diamond': '&#xf100;',	
		'vh-diamond-empty': '&#xf101;',	
		'vh-club': '&#xf102;',	
		'vh-club-empty': '&#xf103;',	
		'vh-triangle': '&#xf104;',	
		'vh-triangle-empty': '&#xf105;',	
		'vh-square': '&#xf106;',	
		'vh-square-empty': '&#xf107;',	
		'vh-hexagon': '&#xf108;',	
		'vh-hexagon-empty': '&#xf109;',	
		'vh-hexagon-1': '&#xf10a;',	
		'vh-hexagon-1-empty': '&#xf10b;',	
		'vh-octagon': '&#xf10c;',	
		'vh-octagon-empty': '&#xf10d;',	
		'vh-octagon-1': '&#xf10e;',	
		'vh-octagon-1-empty': '&#xf10f;',	
		'vh-circle': '&#xf110;',	
		'vh-round': '&#xf110;',	// Alias
		'vh-circle-empty': '&#xf111;',	
		'vh-round-empty': '&#xf111;',	// Alias
		'vh-arrow-left-slim': '&#xf112;',	
		'vh-arrow-right-slim': '&#xf113;',	
		'vh-arrow-up-slim': '&#xf114;',	
		'vh-arrow-down-slim': '&#xf115;',	
		'vh-arrow-left': '&#xf116;',	
		'vh-arrow-right': '&#xf117;',	
		'vh-arrow-up': '&#xf118;',	
		'vh-arrow-down': '&#xf119;',	
		'vh-angle-double-left': '&#xf11a;',	
		'vh-angle-double-right': '&#xf11b;',	
		'vh-angle-double-up': '&#xf11c;',	
		'vh-angle-double-down': '&#xf11d;',	
		'vh-angle-left': '&#xf11e;',	
		'vh-angle-right': '&#xf11f;',	
		'vh-angle-up': '&#xf120;',	
		'vh-angle-down': '&#xf121;',	
		'vh-sort': '&#xf122;',	
		'vh-sort-down': '&#xf123;',	
		'vh-sort-up': '&#xf124;',	
		'vh-sort-alpha-asc': '&#xf125;',	
		'vh-sort-alpha-desc': '&#xf126;',	
		'vh-sort-numeric-asc': '&#xf127;',	
		'vh-sort-numeric-desc': '&#xf128;',	
		'vh-sort-amount-asc': '&#xf129;',	
		'vh-sort-amount-desc': '&#xf12a;',	
		'vh-map-marker': '&#xf12b;',	
		'vh-map': '&#xf12c;',	
		'vh-currency': '&#xf12d;',	
		'vh-money': '&#xf12d;',	// Alias
		'vh-euro': '&#xf12e;',	
		'vh-eur': '&#xf12e;',	// Alias
		'vh-pound': '&#xf12f;',	
		'vh-gbp': '&#xf12f;',	// Alias
		'vh-dollar': '&#xf130;',	
		'vh-usd': '&#xf130;',	// Alias
		'vh-rupee': '&#xf131;',	
		'vh-inr': '&#xf131;',	// Alias
		'vh-yen': '&#xf132;',	
		'vh-cny': '&#xf132;',	// Alias
		'vh-jpy': '&#xf132;',	// Alias
		'vh-rmb': '&#xf132;',	// Alias
		'vh-rouble': '&#xf133;',	
		'vh-rub': '&#xf133;',	// Alias
		'vh-ruble': '&#xf133;',	// Alias
		'vh-won': '&#xf134;',	
		'vh-krw': '&#xf134;',	// Alias
		'vh-bitcoin': '&#xf135;',	
		'vh-btc': '&#xf135;',	// Alias
		'vh-viacoin': '&#xf136;',	
		// 'vh-': '&#xf137;',	
		// 'vh-': '&#xf138;',	
		// 'vh-': '&#xf139;',	
		// 'vh-': '&#xf13a;',	
		// 'vh-': '&#xf13b;',	
		// 'vh-': '&#xf13c;',	
		// 'vh-': '&#xf13d;',	
		// 'vh-': '&#xf13e;',	
		// 'vh-': '&#xf13f;',	
		// 'vh-': '&#xf140;',	
		// 'vh-': '&#xf141;',	
		// 'vh-': '&#xf142;',	
		// 'vh-': '&#xf143;',	
		// 'vh-': '&#xf144;',	
		// 'vh-': '&#xf145;',	
		// 'vh-': '&#xf146;',	
		// 'vh-': '&#xf147;',	
		// 'vh-': '&#xf148;',	
		// 'vh-': '&#xf149;',	
		'vh-face-happy': '&#xf14a;',	
		'vh-face-neutral': '&#xf14b;',	
		'vh-face-sad': '&#xf14c;',	
		// 'vh-': '&#xf14d;',	
		'vh-phone-o': '&#xf14e;',	
		'vh-ip': '&#xf14f;',	
		'vh-manager': '&#xf150;',	
		'vh-officer': '&#xf150;',	// Alias
		'vh-mail-forward': '&#xf151;',	
		'vh-mail-reply': '&#xf152;',	
		'vh-mail-reply-all': '&#xf153;',	
		'vh-trophy': '&#xf154;',	
		'vh-trophy-star': '&#xf155;',	
		'vh-trophy-50': '&#xf156;',	
		'vh-trophy-100': '&#xf157;',	
		'vh-trophy-150': '&#xf158;',	
		'vh-trophy-200': '&#xf159;',	
		'vh-trophy-250': '&#xf15a;',	
		'vh-trophy-300': '&#xf15b;',	
		'vh-trophy-500': '&#xf15c;',	
		'vh-medal': '&#xf15d;',	
		'vh-guest-of-honor': '&#xf15e;',	
		'vh-support-call': '&#xf15f;',	
		'vh-outward-call': '&#xf160;',	
		'vh-inward-call': '&#xf161;',	
		'vh-explorer': '&#xf162;',	
		'vh-scholar': '&#xf163;',	
		'vh-perfectionist': '&#xf163;',	// Alias
		'vh-cafeholic': '&#xf164;',	
		'vh-glass': '&#xf165;',	
		'vh-cake': '&#xf166;',	
		'vh-sweet': '&#xf166;',	// Alias
		'vh-money-bag': '&#xf167;',	
		'vh-banker': '&#xf167;',	// Alias
		'vh-scooter': '&#xf168;',	
		'vh-car': '&#xf169;',	
		'vh-rocket': '&#xf16a;',	
		'vh-rocket-1': '&#xf16b;',	
		'vh-atomic': '&#xf16c;',	
		'vh-atom': '&#xf16c;',	// Alias
		'vh-dynamite': '&#xf16d;',	
		'vh-bomb': '&#xf16d;',	// Alias
		'vh-lab': '&#xf16e;',	
		'vh-test': '&#xf16e;',	// Alias
		'vh-druid': '&#xf16e;',	// Alias
		'vh-performance': '&#xf16f;',	
		'vh-pie-chart': '&#xf170;',	
		'vh-statistician': '&#xf170;',	// Alias
		'vh-smiley': '&#xf171;',	
		'vh-flag-bearer': '&#xf172;',	
		'vh-quotes': '&#xf173;',	
		'vh-conversationalist': '&#xf174;',	
		'vh-commentor': '&#xf175;',	
		'vh-bureaucrat': '&#xf176;',	
		'vh-minuteman': '&#xf177;',	
		'vh-book': '&#xf178;',	
		'vh-bibliophile': '&#xf178;',	// Alias
		'vh-books': '&#xf179;',	
		'vh-news-paper': '&#xf17a;',	
		'vh-knowledgebase': '&#xf17b;',	
		'vh-target': '&#xf17c;',	
		'vh-tools': '&#xf17d;',	
		'vh-fixer': '&#xf17d;',	// Alias
		'vh-zeus': '&#xf17e;',	
		'vh-football': '&#xf17f;',	
		'vh-goal': '&#xf17f;',	// Alias
		'vh-striker': '&#xf17f;',	// Alias
		'vh-game': '&#xf180;',	
		'vh-speed-eater': '&#xf181;',	
		'vh-gentleman': '&#xf182;',	
		'vh-table-lamp': '&#xf183;',	
		'vh-beacon': '&#xf183;',	// Alias
		'vh-feather': '&#xf184;',	
		'vh-scripter': '&#xf184;',	// Alias
		'vh-brush': '&#xf185;',	
		'vh-artist': '&#xf185;',	// Alias
		'vh-pen': '&#xf186;',	
		'vh-writer': '&#xf186;',	// Alias
		'vh-pencil': '&#xf187;',	
		'vh-marker': '&#xf188;',	
		'vh-start': '&#xf189;',	
		'vh-gift': '&#xf18a;',	
		'vh-bell-empty': '&#xf18b;',	
		'vh-members': '&#xf18c;',	
		'vh-crowd': '&#xf18c;',	// Alias
		'vh-moon': '&#xf18d;',	
		'vh-balb': '&#xf18e;',	
		'vh-badge-bg': '&#xf18f;',	
		'vh-crop': '&#xf190;',	
		'vh-download': '&#xf191;',	
		'vh-upload': '&#xf192;',	
		'vh-security': '&#xf193;',	
		'vh-guard': '&#xf193;',	// Alias
		'vh-task': '&#xf194;',	
		'vh-checkbox': '&#xf195;',	
		'vh-crossbox': '&#xf196;',	
		'vh-survey': '&#xf197;',	
		'vh-survey-fields': '&#xf198;',	
		'vh-survey-fields-1': '&#xf199;',	
		'vh-survey-fields-2': '&#xf19a;',	
		'vh-activity-log': '&#xf19b;',	
		'vh-broomstick': '&#xf19c;',	
		'vh-spraybottles': '&#xf19d;',	
		'vh-sugarcrm': '&#xf19e;',	
		'vh-salesforce': '&#xf19f;',	
		'vh-livezilla': '&#xf1a0;',	
		'vh-livechat-inc': '&#xf1a1;',	
		'vh-zopim': '&#xf1a2;',	
		'vh-teamviewer': '&#xf1a3;',	
		'vh-gotomeeting': '&#xf1a4;',	
		'vh-gotoassist': '&#xf1a5;',	
		'vh-gotomypc': '&#xf1a6;',	
		'vh-twilio': '&#xf1a7;',	
		'vh-hostbill': '&#xf1a8;',	
		'vh-zapier': '&#xf1a9;',	
		'vh-comm100': '&#xf1aa;',	
		'vh-userlike': '&#xf1ab;',	
		'vh-kayako': '&#xf1ac;',	
		'vh-zendesk': '&#xf1ad;',	
		'vh-freshdesk': '&#xf1ae;',	
		'vh-whoson': '&#xf1af;',	
		'vh-assistly': '&#xf1b0;',	
		'vh-desk': '&#xf1b1;',	
		'vh-clickdesk': '&#xf1b2;',	
		'vh-freshbooks': '&#xf1b3;',	
		'vh-insightly': '&#xf1b4;',	
		'vh-helpscout': '&#xf1b5;',	
		'vh-bigcommerce': '&#xf1b6;',	
		'vh-clickatell': '&#xf1b7;',	
		'vh-atlassian': '&#xf1b8;',	
		'vh-atlassian-bitbucket': '&#xf1b9;',	
		'vh-atlassian-bomboo': '&#xf1ba;',	
		'vh-atlassian-bonfire': '&#xf1bb;',	
		'vh-atlassian-cloud': '&#xf1bc;',	
		'vh-atlassian-clover': '&#xf1bd;',	
		'vh-atlassian-confluence': '&#xf1be;',	
		'vh-atlassian-crowd': '&#xf1bf;',	
		'vh-atlassian-crucible': '&#xf1c0;',	
		'vh-atlassian-fisheye': '&#xf1c1;',	
		'vh-atlassian-hipchat': '&#xf1c2;',	
		'vh-atlassian-ide': '&#xf1c3;',	
		'vh-atlassian-jira': '&#xf1c4;',	
		'vh-atlassian-sourcetree': '&#xf1c5;',	
		'vh-atlassian-stash': '&#xf1c6;',	
		'vh-2sms': '&#xf1c7;',	
		'vh-azure-active-directory': '&#xf1c8;',	
		'vh-active-directory': '&#xf1c9;',	
		'vh-ldap': '&#xf1c9;',	// Alias
		'vh-plesk-billing': '&#xf1ca;',	
		'vh-whmcs': '&#xf1cb;',	
		'vh-blesta': '&#xf1cc;',	
		'vh-clientexec': '&#xf1cd;',	
		'vh-oscommerce': '&#xf1ce;',	
		'vh-vbulletin': '&#xf1cf;',	
		'vh-smf': '&#xf1d0;',	
		'vh-wordpress': '&#xf1d1;',	
		'vh-spbas': '&#xf1d2;',	
		'vh-prestashop': '&#xf1d3;',	
		'vh-moodle': '&#xf1d4;',	
		'vh-magento': '&#xf1d5;',	
		'vh-drupal': '&#xf1d6;',	
		'vh-joomla': '&#xf1d7;',	
		'vh-php-nuke': '&#xf1d8;',	
		'vh-invision': '&#xf1d9;',	
		'vh-phplicengine': '&#xf1da;',	
		'vh-ms-exchange': '&#xf1db;',	
		'vh-mailchimp': '&#xf1dc;',	
		'vh-ms-office365': '&#xf1dd;',	
		'vh-exotel': '&#xf1de;',	
		'vh-redmine': '&#xf1df;',	
		'vh-capsulecrm': '&#xf1e0;',	
		'vh-slack': '&#xf1e1;',	
		'vh-webex': '&#xf1e2;',	
		'vh-harvest': '&#xf1e3;',	
		'vh-tawkto': '&#xf1e4;',	
		'vh-olark': '&#xf1e5;',	
		'vh-crisp': '&#xf1e6;',	
		'vh-intercom': '&#xf1e7;',	
		'vh-jivochat': '&#xf1e8;',	
		'vh-sso': '&#xf1e9;',	
		'vh-vtiger': '&#xf1ea;',	
		'vh-dropbox': '&#xf1eb;',	
		'vh-gravatar': '&#xf1ec;',	
		'vh-aircall': '&#xf1ed;',	
		'vh-google-drive': '&#xf1ee;',	
		'vh-google-play': '&#xf1ef;',	
		'vh-ms-onedrive': '&#xf1f0;',	
		'vh-box': '&#xf1f1;',	
		'vh-quickbooks': '&#xf1f2;',	
		'vh-opencart': '&#xf1f3;',	
		'vh-asterisk': '&#xf1f4;',	
		'vh-munic-connect': '&#xf1f5;',	
		'vh-jfrog-bintray': '&#xf1f6;',	
		'vh-xero': '&#xf1f7;',	
		// 'vh-': '&#xf1f8;',	
		// 'vh-': '&#xf1f9;',	
		// 'vh-': '&#xf1fa;',	
		// 'vh-': '&#xf1fb;',	
		// 'vh-': '&#xf1fc;',	
		// 'vh-': '&#xf1fd;',	
		// 'vh-': '&#xf1fe;',	
		// 'vh-': '&#xf1ff;',	
		// 'vh-': '&#xf200;',	
		// 'vh-': '&#xf201;',	
		// 'vh-': '&#xf202;',	
		// 'vh-': '&#xf203;',	
		// 'vh-': '&#xf204;',	
		// 'vh-': '&#xf205;',	
		// 'vh-': '&#xf206;',	
		// 'vh-': '&#xf207;',	
		'vh-round-robin': '&#xf208;',	
		'vh-my-drive': '&#xf209;',	
		'vh-folder-o': '&#xf20a;',	
		'vh-envelope-open': '&#xf20b;',	
		'vh-ticket-view': '&#xf20c;',	
		'vh-itil': '&#xf20d;',	
		'vh-itsm': '&#xf20e;',	
		'vh-organisation': '&#xf20f;',	
		'vh-forum': '&#xf210;',	
		'vh-refresh': '&#xf211;',	
		'vh-spinner': '&#xf212;',	
		'vh-contract-management': '&#xf213;',	
		'vh-cmdb': '&#xf214;',	
		'vh-incident-management': '&#xf215;',	
		'vh-asset-management': '&#xf216;',	
		'vh-configuration-item': '&#xf217;',	
		'vh-impact-management': '&#xf218;',	
		'vh-risk-management': '&#xf219;',	
		'vh-change-management': '&#xf21a;',	
		'vh-contract-type': '&#xf21b;',	
		'vh-asset-state': '&#xf21c;',	
		'vh-request-stage': '&#xf21d;',	
		'vh-locations': '&#xf21e;',	
		'vh-finance-management': '&#xf21f;',	
		'vh-finance-type': '&#xf220;',	
		'vh-ci-product-status': '&#xf221;',	
		'vh-mode-of-procurement': '&#xf222;',	
		'vh-depreciation-type': '&#xf223;',	
		'vh-ci-product': '&#xf224;',	
		'vh-service-category': '&#xf225;',	
		'vh-service-item': '&#xf226;',	
		'vh-release-management': '&#xf227;',	
		'vh-bag': '&#xf228;',	
		'vh-bug': '&#xf229;',	
		'vh-order-request': '&#xf22a;',	
		'vh-locker': '&#xf22b;',	
		'vh-piggy-bank': '&#xf22c;',	
		'vh-www-globe': '&#xf22d;',	
		'vh-imac': '&#xf22e;',	
		'vh-macbook-pro': '&#xf22f;',	
		'vh-surface-pro-landscape': '&#xf230;',	
		'vh-surface-pro-portrait': '&#xf231;',	
		'vh-ipad-air-landscape': '&#xf232;',	
		'vh-ipad-air-portrait': '&#xf233;',	
		'vh-nexus9-landscape': '&#xf234;',	
		'vh-nexus9-portrait': '&#xf235;',	
		'vh-microsoft-lumia': '&#xf236;',	
		'vh-nexus6': '&#xf237;',	
		'vh-iphone6': '&#xf238;',	
		'vh-ipod-shuffle': '&#xf239;',	
		'vh-ipod-nano': '&#xf23a;',	
		'vh-keyboard': '&#xf23b;',	
		'vh-mouse': '&#xf23c;',	
		'vh-server': '&#xf23d;',	
		'vh-stethoscope': '&#xf23e;',	
		'vh-safari': '&#xf23f;',	
		'vh-chrome': '&#xf240;',	
		'vh-firefox': '&#xf241;',	
		'vh-opera': '&#xf242;',	
		'vh-internet-explorer': '&#xf243;',	
		'vh-ie': '&#xf243;',	// Alias
		'vh-edge': '&#xf244;',	
		'vh-apple': '&#xf245;',	
		'vh-ms-windows': '&#xf246;',	
		'vh-linux': '&#xf247;',	
		'vh-android': '&#xf248;',	
		'vh-ms-windows-store': '&#xf249;',	
		'vh-blackberry': '&#xf24a;',	
		// 'vh-': '&#xf24b;',	
		// 'vh-': '&#xf24c;',	
		// 'vh-': '&#xf24d;',	
		// 'vh-': '&#xf24e;',	
		// 'vh-': '&#xf24f;',	
		// 'vh-': '&#xf250;',	
		// 'vh-': '&#xf251;',	
		// 'vh-': '&#xf252;',	
		// 'vh-': '&#xf253;',	
		// 'vh-': '&#xf254;',	
		// 'vh-': '&#xf255;',	
		// 'vh-': '&#xf256;',	
		// 'vh-': '&#xf257;',	
		// 'vh-': '&#xf258;',	
		// 'vh-': '&#xf259;',	
		// 'vh-': '&#xf25a;',	
		// 'vh-': '&#xf25b;',	
		// 'vh-': '&#xf25c;',	
		// 'vh-': '&#xf25d;',	
		// 'vh-': '&#xf25e;',	
		// 'vh-': '&#xf25f;',	
		'vh-html': '&#xf260;',	
		'vh-quote': '&#xf261;',	
		'vh-code': '&#xf262;',	
		'vh-font': '&#xf263;',	
		'vh-paragraph': '&#xf264;',	
		'vh-text-format': '&#xf264;',	// Alias
		'vh-font-size': '&#xf265;',	
		'vh-text-color': '&#xf266;',	
		'vh-text-bg-color': '&#xf267;',	
		'vh-text-background-color': '&#xf267;',	// Alias
		'vh-font-style': '&#xf268;',	
		'vh-text-height': '&#xf269;',	
		'vh-text-width': '&#xf26a;',	
		'vh-line-height': '&#xf26b;',	
		'vh-unordered-list': '&#xf26c;',	
		'vh-ordered-list': '&#xf26d;',	
		'vh-indent': '&#xf26e;',	
		'vh-outdent': '&#xf26f;',	
		'vh-clip': '&#xf270;',	
		'vh-header': '&#xf271;',	
		'vh-header-1': '&#xf272;',	
		'vh-header-2': '&#xf273;',	
		'vh-header-3': '&#xf274;',	
		'vh-header-4': '&#xf275;',	
		'vh-header-5': '&#xf276;',	
		'vh-header-6': '&#xf277;',	
		'vh-bold': '&#xf278;',	
		'vh-italic': '&#xf279;',	
		'vh-underline': '&#xf27a;',	
		'vh-strikethrough': '&#xf27b;',	
		'vh-superscript': '&#xf27c;',	
		'vh-subscript': '&#xf27d;',	
		'vh-change-case': '&#xf27e;',	
		'vh-align-none': '&#xf27f;',	
		'vh-align-left': '&#xf280;',	
		'vh-alignment': '&#xf280;',	// Alias
		'vh-align-center': '&#xf281;',	
		'vh-align-right': '&#xf282;',	
		'vh-align-justify': '&#xf283;',	
		'vh-direction': '&#xf284;',	
		'vh-table': '&#xf285;',	
		'vh-full-screen': '&#xf286;',	
		'vh-normal-screen': '&#xf287;',	
		'vh-cut': '&#xf288;',	
		'vh-scissor': '&#xf288;',	// Alias
		'vh-copy': '&#xf289;',	
		'vh-paste': '&#xf28a;',	
		'vh-floppy': '&#xf28b;',	
		'vh-save': '&#xf28b;',	// Alias
		'vh-undo': '&#xf28c;',	
		'vh-redo': '&#xf28d;',	
		'vh-image': '&#xf28e;',	
		'vh-images': '&#xf28f;',	
		'vh-gallery': '&#xf28f;',	// Alias
		'vh-video': '&#xf290;',	
		'0': 0
		},
		els = document.getElementsByTagName('*'),
		i, c, el;
	for (i = 0; ; i += 1) {
		el = els[i];
		if(!el) {
			break;
		}
		c = el.className;
		c = c.match(/vh-[^\s'"]+/);
		if (c && icons[c[0]]) {
			addIcon(el, icons[c[0]]);
		}
	}
}());
